/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: CRuntime.cpp,v 1.3 1999/10/25 03:58:25 nryan Exp $
____________________________________________________________________________*/

#include "pgpClassesConfig.h"
#include "UDebug.h"

_USING_PGP

#if defined(PGP_DRIVER98) || defined(PGP_DRIVERNT)

// C runtime library functions

extern "C" 
void * 
_cdecl 
malloc(size_t size)
{
	unsigned char *newBlock;

	newBlock = new unsigned char[size + sizeof(size_t)];

	if (newBlock == NULL)
		return NULL;

	((size_t *) newBlock)[0] = size;

	return (newBlock + sizeof(size_t));
}

extern "C" 
void
_cdecl 
free(void *memBlock)
{
	unsigned char *actualMemBlock;

	actualMemBlock = ((unsigned char *) memBlock) - sizeof(size_t);

	delete[] actualMemBlock;
}

extern "C" 
void * 
_cdecl 
realloc(void *oldBlock, size_t size)
{
	size_t			oldSize;
	unsigned char	*actualOldBlock;
	void			*newBlock;
	
	if (oldBlock == NULL)
		return malloc(size);

	actualOldBlock = ((unsigned char *) oldBlock) - sizeof(size_t);
	oldSize = ((size_t *) actualOldBlock)[0];

	if (size == 0)
	{
		free(actualOldBlock);
		return NULL;
	}

	newBlock = malloc(size);

	if (newBlock == NULL)
		return NULL;

	memmove(newBlock, oldBlock, (size < oldSize ? size : oldSize));

	return newBlock;
}

extern "C" 
void * 
_cdecl 
memmove(void *dest, const void *src, size_t count)
{
	PGPByte			*dest1	= static_cast<PGPByte *>(dest);
	const PGPByte	*src1	= static_cast<const PGPByte *>(src);

	if ((dest1 <= src1) || (dest1 >= (src1 + count)))
	{
		while (count--)
		{
			*dest1 = *src1;

			dest1++;
			src1++;
		}
	}
	else
	{
		dest1 += count - 1;
		src1 += count - 1;

		while (count--)
		{
			*dest1 = *src1;

			dest1--;
			src1--;
		}
	}

	return dest;
}

extern "C" 
int 
_cdecl 
tolower(int c)
{
	if ((c >= 'A') && (c <= 'Z'))
		c  = c - 'A' + 'a';

	return c;
}

extern "C" 
int 
_cdecl 
toupper(int c)
{
	if ((c >= 'a') && (c <= 'z'))
		c = c - 'a' + 'A';

	return c;
}

extern "C" 
int 
_cdecl 
strncmp(const char *string1, const char *string2, size_t count)
{
	while ((count > 0) && (*string1 != 0) && (*string2 != 0) && 
		(*string1 == *string2))
	{
		string1++;
		string2++;
		count--;
	}
	
	return ((count == 0) ? 0 : *string1 - *string2);
}

extern "C" 
int 
_cdecl 
_stricmp(const char *string1, const char *string2)
{
	while ((*string1 != 0) && (*string2 != 0) && 
		(tolower(*string1) == tolower(*string2)))
	{
		string1++;
		string2++;
	}

	return (*string1 - *string2);
}

extern "C" 
int 
_cdecl 
_strnicmp(const char *string1, const char *string2, size_t count)
{
	while ((count > 0) && (*string1 != 0) && (*string2 != 0) && 
		(tolower(*string1) == tolower(*string2)))
	{
		string1++;
		string2++;
		count--;
	}
	
	return ((count == 0) ? 0 : *string1 - *string2);
}

extern "C" 
char * 
_cdecl 
strncat(char *strDest, const char *strSource, size_t count)
{
	char	*oldDest	= strDest;

	while (*strDest++);
	strDest--;

	while (count--)
	{
		if (!(*strDest++ = *strSource++))
			return oldDest;
	}

	*strDest = '\0';

	return oldDest;
}

extern "C" 
char * 
_cdecl 
strncpy(char *strDest, const char *strSource, size_t count)
{
	char	*oldDest	= strDest;

	while (count && (*strDest++ = *strSource++))
	{
		count--;
	}

	if (count)
	{
		while (--count)
		{
			*strDest++ = '\0';
		}
	}

	return oldDest;
}

extern "C" 
char * 
_cdecl 
strstr(const char *string, const char *strCharSet)
{
	char	*cp	= const_cast<char *>(string);
	char	*s1, *s2;

	if (!*strCharSet)
		return cp;

	while (*cp)
	{
		s1 = cp;
		s2 = const_cast<char *>(strCharSet);

		while (*s1 && *s2 && !(*s1 - *s2))
			s1++, s2++;

		if (!*s2)
			return cp;

		cp++;
	}

	return NULL;
}

extern "C" 
int 
_cdecl 
sprintf(char *buffer, const char *format, ...)
{
	int		numWritten;
	va_list	args;
	
	va_start(args, format);
	numWritten = pgpFormatVAStr(reinterpret_cast<PGPByte *>(buffer), 
		0x7000, FALSE, TRUE, FALSE, format, args);
	va_end(args);

	return numWritten;
}

extern "C" 
int 
_cdecl 
_snprintf(char *buffer, size_t count, const char *format, ...)
{
	int		numWritten;
	va_list	args;
	
	va_start(args, format);
	numWritten = pgpFormatVAStr(reinterpret_cast<PGPByte *>(buffer), 
		count, FALSE, TRUE, FALSE, format, args);
	va_end(args);

	return numWritten;
}

extern "C" 
int 
_cdecl 
vsprintf(char *buffer, const char *format, va_list argptr)
{
	return pgpFormatVAStr(reinterpret_cast<PGPByte *>(buffer), 0x7000, 
		FALSE, TRUE, FALSE, format, argptr);
}

extern "C" 
int 
_cdecl 
_vsnprintf(char *buffer, size_t count, const char *format, va_list argptr)
{
	return pgpFormatVAStr(reinterpret_cast<PGPByte *>(buffer), count, 
		FALSE, TRUE, FALSE, format, argptr);
}

extern "C" 
int 
__cdecl 
_CrtDbgReport(
	int			nRptType, 
	const char	*szFile, 
	int			nLine, 
	const char	*szModule, 
	const char	*szFormat, 
	...)
{
	static char	szUserMessage[UDebug::kMaxLengthString];
	va_list		arglist;

	va_start(arglist, szFormat);
	_vsnprintf(szUserMessage, UDebug::kMaxLengthString, "\n%s\n\n", 
		arglist);
	va_end(arglist);

	UDebug::DebugOut(szUserMessage);

	return 1;
}

#endif	// PGP_DRIVER98 || PGP_DRIVERNT
